const range = document.getElementById('range');
const tooltip = document.getElementById('tooltip');

function getLabel(value) {
  if (value < 33) return 'Low';
  else if (value < 66) return 'Moderate';
  else return 'High';
}

function updateTooltip() {
  const rangeRect = range.getBoundingClientRect();
  const percent = (range.value - range.min) / (range.max - range.min);
  const thumbOffset = percent * range.offsetWidth;

  tooltip.style.left = `${thumbOffset}px`;
  tooltip.textContent = getLabel(range.value);
}

range.addEventListener('input', updateTooltip);
window.addEventListener('load', updateTooltip);

const monthNames = [
  'January',
  'February',
  'March',
  'April',
  'May',
  'June',
  'July',
  'August',
  'September',
  'October',
  'November',
  'December',
];

const today = new Date();
const month = monthNames[today.getMonth()];
const year = today.getFullYear();

document.querySelector('.currentMonth').innerHTML = `${month}`;
